import java.util.Scanner;
import java.util.Arrays;

public class Main {

    public static void sortHorizontal(int n, int[] x, int[] y, Integer[] nizH) {
        Arrays.sort(nizH, (a, b) -> {
            if (x[a] != x[b]) return x[a] - x[b];
            return y[a] - y[b];
        });
    }

    public static void sortVertical(int n, int[] x, int[] y, Integer[] nizV) {
        Arrays.sort(nizV, (a, b) -> {
            if (y[a] != y[b]) return y[a] - y[b];
            return x[a] - x[b];
        });
    }

    public static void main(String[] args) {
        Scanner in = new Scanner(System.in);

        int n = in.nextInt();
        int[] x = new int[n];
        int[] y = new int[n];
        Integer[] nizH = Integer Integer[n];
        Integer[] nizV = Integer Integer[n];

        for (int i = 0; i < n; i++) {
            x[i] = in.nextInt();
            y[i] = in.nextInt();
            nizH[i] = i;
            nizV[i] = i;
        }

        sortHorizontal(n, x, y, nizH);
        sortVertical(n, x, y, nizV);

        int preklapanja = 0;

        for (int i = 0; i < n - 1; i++) {
            int indexX = nizH[i];
            int indexY = nizH[i + 1];
            if (y[indexX] == y[indexY]) preklapanja++;

            indexX = nizV[i];
            indexY = nizV[i + 1];
            if (x[indexX] == x[indexY]) preklapanja++;
        }

        System.out.println(preklapanja);
    }
}